/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block.component;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.technicalitiesmc.lib.block.BlockComponent;
import com.technicalitiesmc.lib.block.CustomBlockHighlight;
import com.technicalitiesmc.lib.init.TKLibItemTags;
import com.technicalitiesmc.lib.math.IndexedShape;
import com.technicalitiesmc.lib.math.MergedShape;
import com.technicalitiesmc.lib.math.ShapeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockConnections<T extends Comparable<T>>
extends BlockComponent.WithoutData {
    private final Map<Direction, ? extends Property<T>> properties;
    private final VoxelShape centerShape;
    private final Table<Direction, T, VoxelShape> sideShapes;
    private final StateGetter<T> stateGetter;
    private final HighlightHandler highlightHandler;

    private BlockConnections(BlockComponent.Context context, Map<Direction, ? extends Property<T>> properties, VoxelShape centerShape, Table<Direction, T, VoxelShape> sideShapes, StateGetter<T> stateGetter, @Nullable FineHighlightPredicate fineHighlightPredicate) {
        super(context);
        this.properties = properties;
        this.centerShape = centerShape;
        this.sideShapes = sideShapes;
        this.stateGetter = stateGetter;
        this.highlightHandler = fineHighlightPredicate != null ? new HighlightHandler(fineHighlightPredicate) : HighlightHandler.ALWAYS;
    }

    public static <T extends Comparable<T>> BlockComponent.Constructor<BlockConnections<T>> of(EnumMap<Direction, ? extends Property<T>> properties, VoxelShape centerShape, Function<T, VoxelShape> sideShapeFactory, StateGetter<T> stateGetter, @Nullable FineHighlightPredicate fineHighlightPredicate) {
        Set<Comparable> values = properties.values().stream().map(Property::m_6908_).flatMap(Collection::stream).collect(Collectors.toSet());
        HashBasedTable sideShapes = HashBasedTable.create();
        values.forEach(val -> {
            VoxelShape baseShape = (VoxelShape)sideShapeFactory.apply(val);
            if (baseShape != null) {
                for (Direction side : properties.keySet()) {
                    sideShapes.put((Object)side, val, (Object)new IndexedShape(side.ordinal(), ShapeUtils.rotate(baseShape, side)));
                }
            }
        });
        return ctx -> new BlockConnections(ctx, properties, centerShape, sideShapes, stateGetter, fineHighlightPredicate);
    }

    public static BlockComponent.Constructor<BlockConnections<Boolean>> of(EnumMap<Direction, BooleanProperty> properties, VoxelShape centerShape, VoxelShape sideShape, StateGetter<Boolean> stateGetter, @Nullable FineHighlightPredicate fineHighlightPredicate) {
        return BlockConnections.of(properties, centerShape, (T b) -> b != false ? sideShape : null, stateGetter, fineHighlightPredicate);
    }

    public VoxelShape shape(BlockState state) {
        ArrayList<VoxelShape> list = new ArrayList<VoxelShape>();
        list.add(this.centerShape);
        this.properties.forEach((side, property) -> {
            Comparable value = state.m_61143_(property);
            VoxelShape shape = (VoxelShape)this.sideShapes.get(side, (Object)value);
            if (shape != null) {
                list.add(shape);
            }
        });
        return MergedShape.ofMerged(list);
    }

    @Override
    @Nullable
    protected Object getInterface(Class<?> itf) {
        if (itf == CustomBlockHighlight.class) {
            return this.highlightHandler;
        }
        return super.getInterface(itf);
    }

    @Override
    protected BlockState getStateForPlacement(BlockPlaceContext context, BlockState state) {
        if (context.m_43725_().m_5776_()) {
            return state;
        }
        for (Map.Entry<Direction, Property<T>> entry : this.properties.entrySet()) {
            T sideState = this.stateGetter.getState((BlockGetter)context.m_43725_(), context.m_8083_(), state, entry.getKey());
            state = (BlockState)state.m_61124_(entry.getValue(), sideState);
        }
        return state;
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction side, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (level.m_5776_()) {
            return state;
        }
        Property<T> property = this.properties.get(side);
        T sideState = this.stateGetter.getState((BlockGetter)level, pos, state, side);
        return (BlockState)state.m_61124_(property, sideState);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape(state);
    }

    public static boolean isHoldingWrench(Level level, BlockHitResult target, Player player) {
        return player.m_21205_().m_204117_(TKLibItemTags.TOOLS_WRENCH);
    }

    @FunctionalInterface
    public static interface StateGetter<T extends Comparable<T>> {
        public T getState(BlockGetter var1, BlockPos var2, BlockState var3, Direction var4);
    }

    private record HighlightHandler(FineHighlightPredicate predicate) implements CustomBlockHighlight
    {
        public static final HighlightHandler ALWAYS = new HighlightHandler((level, target, player) -> true);

        @Override
        @Nullable
        public VoxelShape getCustomHighlightShape(Level level, BlockHitResult target, Player player) {
            if (this.predicate.shouldDisplayFineHighlight(level, target, player)) {
                return CustomBlockHighlight.getShapeFromHit(target);
            }
            return null;
        }
    }

    @FunctionalInterface
    public static interface FineHighlightPredicate {
        public boolean shouldDisplayFineHighlight(Level var1, BlockHitResult var2, Player var3);
    }
}

